// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/cloud/contentwarehouse/v1/synonymset_service_request.proto

package contentwarehouse

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Request message for SynonymSetService.CreateSynonymSet.
type CreateSynonymSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent name.
	// Format: projects/{project_number}/locations/{location}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The synonymSet to be created for a context
	SynonymSet *SynonymSet `protobuf:"bytes,2,opt,name=synonym_set,json=synonymSet,proto3" json:"synonym_set,omitempty"`
}

func (x *CreateSynonymSetRequest) Reset() {
	*x = CreateSynonymSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateSynonymSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateSynonymSetRequest) ProtoMessage() {}

func (x *CreateSynonymSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateSynonymSetRequest.ProtoReflect.Descriptor instead.
func (*CreateSynonymSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_rawDescGZIP(), []int{0}
}

func (x *CreateSynonymSetRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateSynonymSetRequest) GetSynonymSet() *SynonymSet {
	if x != nil {
		return x.SynonymSet
	}
	return nil
}

// Request message for SynonymSetService.GetSynonymSet.
// Will return synonymSet for a certain context.
type GetSynonymSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the synonymSet to retrieve
	// Format:
	// projects/{project_number}/locations/{location}/synonymSets/{context}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSynonymSetRequest) Reset() {
	*x = GetSynonymSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetSynonymSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSynonymSetRequest) ProtoMessage() {}

func (x *GetSynonymSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSynonymSetRequest.ProtoReflect.Descriptor instead.
func (*GetSynonymSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_rawDescGZIP(), []int{1}
}

func (x *GetSynonymSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for SynonymSetService.ListSynonymSets.
// Will return all synonymSets belonging to the customer project.
type ListSynonymSetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent name.
	// Format: projects/{project_number}/locations/{location}.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// The maximum number of synonymSets to return. The service may return
	// fewer than this value.
	// If unspecified, at most 50 rule sets will be returned.
	// The maximum value is 1000; values above 1000 will be coerced to 1000.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// A page token, received from a previous `ListSynonymSets` call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to `ListSynonymSets`
	// must match the call that provided the page token.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListSynonymSetsRequest) Reset() {
	*x = ListSynonymSetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSynonymSetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSynonymSetsRequest) ProtoMessage() {}

func (x *ListSynonymSetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSynonymSetsRequest.ProtoReflect.Descriptor instead.
func (*ListSynonymSetsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_rawDescGZIP(), []int{2}
}

func (x *ListSynonymSetsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSynonymSetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSynonymSetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for SynonymSetService.ListSynonymSets.
type ListSynonymSetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The synonymSets from the specified parent.
	SynonymSets []*SynonymSet `protobuf:"bytes,1,rep,name=synonym_sets,json=synonymSets,proto3" json:"synonym_sets,omitempty"`
	// A page token, received from a previous `ListSynonymSets` call.
	// Provide this to retrieve the subsequent page.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSynonymSetsResponse) Reset() {
	*x = ListSynonymSetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ListSynonymSetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSynonymSetsResponse) ProtoMessage() {}

func (x *ListSynonymSetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSynonymSetsResponse.ProtoReflect.Descriptor instead.
func (*ListSynonymSetsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_rawDescGZIP(), []int{3}
}

func (x *ListSynonymSetsResponse) GetSynonymSets() []*SynonymSet {
	if x != nil {
		return x.SynonymSets
	}
	return nil
}

func (x *ListSynonymSetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request message for SynonymSetService.UpdateSynonymSet.
// Removes the SynonymSet for the specified context and replaces
// it with the SynonymSet in this request.
type UpdateSynonymSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the synonymSet to update
	// Format:
	// projects/{project_number}/locations/{location}/synonymSets/{context}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Required. The synonymSet to be updated for the customer
	SynonymSet *SynonymSet `protobuf:"bytes,2,opt,name=synonym_set,json=synonymSet,proto3" json:"synonym_set,omitempty"`
}

func (x *UpdateSynonymSetRequest) Reset() {
	*x = UpdateSynonymSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateSynonymSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateSynonymSetRequest) ProtoMessage() {}

func (x *UpdateSynonymSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateSynonymSetRequest.ProtoReflect.Descriptor instead.
func (*UpdateSynonymSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_rawDescGZIP(), []int{4}
}

func (x *UpdateSynonymSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *UpdateSynonymSetRequest) GetSynonymSet() *SynonymSet {
	if x != nil {
		return x.SynonymSet
	}
	return nil
}

// Request message for SynonymSetService.DeleteSynonymSet.
type DeleteSynonymSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the synonymSet to delete
	// Format:
	// projects/{project_number}/locations/{location}/synonymSets/{context}.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteSynonymSetRequest) Reset() {
	*x = DeleteSynonymSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteSynonymSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteSynonymSetRequest) ProtoMessage() {}

func (x *DeleteSynonymSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteSynonymSetRequest.ProtoReflect.Descriptor instead.
func (*DeleteSynonymSetRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_rawDescGZIP(), []int{5}
}

func (x *DeleteSynonymSetRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

var File_google_cloud_contentwarehouse_v1_synonymset_service_request_proto protoreflect.FileDescriptor

var file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_rawDesc = []byte{
	0x0a, 0x41, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f,
	0x76, 0x31, 0x2f, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x65, 0x74, 0x5f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75,
	0x73, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70,
	0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61,
	0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x31, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65,
	0x2f, 0x76, 0x31, 0x2f, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x73, 0x65, 0x74, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb7, 0x01, 0x0a, 0x17, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x53,
	0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e,
	0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x52, 0x0a, 0x0b, 0x73, 0x79,
	0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x53, 0x65, 0x74, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x53, 0x65, 0x74, 0x22, 0x5e,
	0x0a, 0x14, 0x47, 0x65, 0x74, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x53, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x79,
	0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x53, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9e,
	0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x53, 0x65,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2a, 0x0a, 0x28, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f,
	0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x92, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x53,
	0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4f, 0x0a, 0x0c, 0x73,
	0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x5f, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73,
	0x65, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x53, 0x65, 0x74, 0x52,
	0x0b, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x53, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f,
	0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54,
	0x6f, 0x6b, 0x65, 0x6e, 0x22, 0xb5, 0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x53,
	0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77,
	0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x53,
	0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x0b, 0x73, 0x79, 0x6e, 0x6f,
	0x6e, 0x79, 0x6d, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31,
	0x2e, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x53, 0x65, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x0a, 0x73, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x53, 0x65, 0x74, 0x22, 0x61, 0x0a, 0x17,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x53, 0x65, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x46, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x32, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x63,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53,
	0x79, 0x6e, 0x6f, 0x6e, 0x79, 0x6d, 0x53, 0x65, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x42,
	0x99, 0x01, 0x0a, 0x24, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61, 0x72, 0x65,
	0x68, 0x6f, 0x75, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x1d, 0x53, 0x79, 0x6e, 0x6f, 0x6e, 0x79,
	0x6d, 0x53, 0x65, 0x74, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x50, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67, 0x65, 0x6e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x77, 0x61,
	0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x2f, 0x76, 0x31, 0x3b, 0x63, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x77, 0x61, 0x72, 0x65, 0x68, 0x6f, 0x75, 0x73, 0x65, 0x62, 0x06, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_rawDescOnce sync.Once
	file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_rawDescData = file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_rawDesc
)

func file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_rawDescGZIP() []byte {
	file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_rawDescOnce.Do(func() {
		file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_rawDescData)
	})
	return file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_rawDescData
}

var file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes = make([]protoimpl.MessageInfo, 6)
var file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_goTypes = []interface{}{
	(*CreateSynonymSetRequest)(nil), // 0: google.cloud.contentwarehouse.v1.CreateSynonymSetRequest
	(*GetSynonymSetRequest)(nil),    // 1: google.cloud.contentwarehouse.v1.GetSynonymSetRequest
	(*ListSynonymSetsRequest)(nil),  // 2: google.cloud.contentwarehouse.v1.ListSynonymSetsRequest
	(*ListSynonymSetsResponse)(nil), // 3: google.cloud.contentwarehouse.v1.ListSynonymSetsResponse
	(*UpdateSynonymSetRequest)(nil), // 4: google.cloud.contentwarehouse.v1.UpdateSynonymSetRequest
	(*DeleteSynonymSetRequest)(nil), // 5: google.cloud.contentwarehouse.v1.DeleteSynonymSetRequest
	(*SynonymSet)(nil),              // 6: google.cloud.contentwarehouse.v1.SynonymSet
}
var file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_depIdxs = []int32{
	6, // 0: google.cloud.contentwarehouse.v1.CreateSynonymSetRequest.synonym_set:type_name -> google.cloud.contentwarehouse.v1.SynonymSet
	6, // 1: google.cloud.contentwarehouse.v1.ListSynonymSetsResponse.synonym_sets:type_name -> google.cloud.contentwarehouse.v1.SynonymSet
	6, // 2: google.cloud.contentwarehouse.v1.UpdateSynonymSetRequest.synonym_set:type_name -> google.cloud.contentwarehouse.v1.SynonymSet
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_init() }
func file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_init() {
	if File_google_cloud_contentwarehouse_v1_synonymset_service_request_proto != nil {
		return
	}
	file_google_cloud_contentwarehouse_v1_synonymset_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateSynonymSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetSynonymSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSynonymSetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ListSynonymSetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateSynonymSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteSynonymSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   6,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_goTypes,
		DependencyIndexes: file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_depIdxs,
		MessageInfos:      file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_msgTypes,
	}.Build()
	File_google_cloud_contentwarehouse_v1_synonymset_service_request_proto = out.File
	file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_rawDesc = nil
	file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_goTypes = nil
	file_google_cloud_contentwarehouse_v1_synonymset_service_request_proto_depIdxs = nil
}
