/*
 * SPDX-License-Identifier: AGPL-3.0-only
 * Copyright (c) 2022-2023, daeuniverse Organization <dae@v2raya.org>
 */

package sniffing

import (
	"encoding/hex"
	"testing"

	"github.com/sirupsen/logrus"
)

var QuicStream, _ = hex.DecodeString("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")

//var QuicStream, _ = hex.DecodeString("c6ff00001d100d5a802c52bfee4d71f3770529a5c6871415ea0d6ef29709e829432a18eb50f3af09c81c75004127f234d23fca9370573fd78cd781f4057ce9940111f0ad20e03e894b232013d76e268299644b036ac4557f03fead23ece9b788b3bcff3492b376861a188d5905e5e07cb156b57d7419e66235bedd44e5e774e1476d344eff64bdb1604aa9755a1fd08d4597a03a205e490f4223ddb32af2fc4023bc6784bcf6622ded2a49bbb976dec36e3712e0016272207f462b93b5a70dc66463131d2375bbfc38ece9215119b0b53676d05d470dcce52460f76d284d8f23846cbb38fcaa7e07fa1d6dec390e2876aea21bbd188dca3fe96dfc8c9f99237564e3db587b240279f46613ccc46c84e1b246cf1536be8275075fa4e63f0750df54f0cfbae986811cf3493c1d6ea63a836f387d1a3a02ac158b433ead3fc2035987f1f9c65c71c2d31803320f7a1a978a1aee3e1a50")

func BenchmarkLinearLocator(b *testing.B) {
	logrus.SetLevel(logrus.DebugLevel)
	QuicReassemble = QuicReassemblePolicy_LinearLocator
	for i := 0; i < b.N; i++ {
		sniffer := NewPacketSniffer(QuicStream)
		d, err := sniffer.SniffQuic()
		if err != nil {
			b.Fatal(err)
		}
		if d == "" {
			b.Fatal(d)
		}
	}
}

func BenchmarkBuiltinSlow(b *testing.B) {
	logrus.SetLevel(logrus.DebugLevel)
	QuicReassemble = QuicReassemblePolicy_Slow
	for i := 0; i < b.N; i++ {
		sniffer := NewPacketSniffer(QuicStream)
		d, err := sniffer.SniffQuic()
		if err != nil {
			b.Fatal(err)
		}
		if d == "" {
			b.Fatal(d)
		}
	}
}

func BenchmarkReassembleCryptoToBytesFromPool(b *testing.B) {
	logrus.SetLevel(logrus.DebugLevel)
	QuicReassemble = QuicReassemblePolicy_ReassembleCryptoToBytesFromPool
	for i := 0; i < b.N; i++ {
		sniffer := NewPacketSniffer(QuicStream)
		d, err := sniffer.SniffQuic()
		if err != nil {
			b.Fatal(err)
		}
		if d == "" {
			b.Fatal(d)
		}
	}
}
